VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   10815
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   15180
   LinkTopic       =   "Form1"
   ScaleHeight     =   721
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   1012
   StartUpPosition =   3  'Windows-Standard
   Begin VB.FileListBox lstFiles 
      Appearance      =   0  '2D
      Height          =   1395
      Left            =   8730
      Pattern         =   "*.svg;*.svgz"
      TabIndex        =   2
      Top             =   60
      Width           =   3165
   End
   Begin VB.CheckBox chkBackgroundPattern 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Show Checker-Pattern"
      Height          =   315
      Left            =   210
      TabIndex        =   1
      Top             =   120
      Width           =   2055
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   -30
      TabIndex        =   0
      Top             =   0
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private SVGRenderBox As cSVGRenderBox
Private WithEvents sldRotate As cSimpleSlider
Attribute sldRotate.VB_VarHelpID = -1
Private WithEvents sldScale As cSimpleSlider
Attribute sldScale.VB_VarHelpID = -1

Private Sub Form_Load()
  Caption = "SVG-Rendering of different Demo-Images - (Note: there are some ""CPU-stressing-ones"" included, which don't ""scale fast"")"
  Me.ScaleMode = vbPixels
  
  Set SVGRenderBox = New cSVGRenderBox
  SVGRenderBox.Init ucCanvas1.ControlPoints, 460, 410
  
  Set sldRotate = New cSimpleSlider
  sldRotate.Init ucCanvas1.ControlPoints, 10, 35, 555, 28, 0, 360, 0
  
  Set sldScale = New cSimpleSlider
  sldScale.Init ucCanvas1.ControlPoints, 10, 70, 555, 28, 0.2, 7, 3.5
  
  lstFiles.Path = App.Path & "\SVGs"
  lstFiles.ListIndex = 0
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub chkBackgroundPattern_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub lstFiles_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub sldRotate_ValueChanged(ByVal NewValue As Double)
  sldRotate.Caption = "Current Angle: " & Round(NewValue, 1)
End Sub

Private Sub sldScale_ValueChanged(ByVal NewValue As Double)
  sldScale.Caption = "Current Scale: " & Round(NewValue, 1)
End Sub

Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim CheckerPat As cCairoPattern, S As String

  'this time we fill the Surface with a checker-pattern (to better demonstrate the transparency-areas of the Alpha-Images)
  CC.PushGroup CAIRO_CONTENT_COLOR_ALPHA, 0, 0, 20, 20
    CC.SetSourceColor vbWhite
    CC.Paint 'up to this point, we only filled the 20x20 Pattern on our "CC-stack" with plain white

    'what remains, are two 10x10 rectangles (diagonally placed and filled with grey)
    'but we make this dependent on the appropriate CheckBox-Value on the Form
    If chkBackgroundPattern.Value Then
      CC.Rectangle 0, 0, 10, 10
      CC.Rectangle 10, 10, 10, 10
        CC.SetSourceColor &HE8E8E8 'a ligth-grey
      CC.Fill
    End If
  CC.SetSourcePattern CC.PopGroup(True, CAIRO_EXTEND_REPEAT)    'this pops up our 20x20 Pattern from the stack - the True-Param ensures, that the clipped Pattern-Region is reset, ...
  CC.Paint '...and CAIRO_EXTEND_REPEAT will ensure, that we fill the whole Surface with it now in our Paint-Method


  If Len(lstFiles.FileName) Then
    SVGRenderBox.Draw CC, lstFiles.Path & "\" & lstFiles.FileName, sldScale.Value, sldRotate.Value
  End If
  
  'finally we redraw our slider-controls too
  sldRotate.Draw CC
  sldScale.Draw CC
  
  ucCanvas1.Refresh
End Sub
